/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections4.ListUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public class OID4VCGeneratedIdMapper
extends OID4VCMapper {
    public static final String MAPPER_ID = "oid4vc-generated-id-mapper";
    private static final String SUBJECT_PROPERTY_CONFIG_KEY_DEFAULT = "id";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public boolean includeInMetadata() {
        return Optional.ofNullable((String)this.mapperModel.getConfig().get("vc.include_in_metadata")).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public List<String> getMetadataAttributePath() {
        String property = Optional.ofNullable(this.mapperModel.getConfig()).map(config -> (String)config.get("claim.name")).orElse(SUBJECT_PROPERTY_CONFIG_KEY_DEFAULT);
        return ListUtils.union(this.getAttributePrefix(), List.of(property));
    }

    @Override
    public void setClaim(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
    }

    @Override
    public void setClaim(Map<String, Object> claims, UserSessionModel userSessionModel) {
        List<String> attributePath = this.getMetadataAttributePath();
        String propertyName = attributePath.get(attributePath.size() - 1);
        claims.put(propertyName, String.format("urn:uuid:%s", UUID.randomUUID()));
    }

    public String getDisplayType() {
        return "Generated ID Mapper";
    }

    public String getHelpText() {
        return "Assigns a generated ID to the credential's subject. The target property can be configured, but `id` is used by default.";
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCGeneratedIdMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    static {
        ProviderConfigProperty idPropertyNameConfig = new ProviderConfigProperty();
        idPropertyNameConfig.setName("claim.name");
        idPropertyNameConfig.setLabel("ID Property Name");
        idPropertyNameConfig.setHelpText("Name of the property to contain the generated id.");
        idPropertyNameConfig.setDefaultValue((Object)SUBJECT_PROPERTY_CONFIG_KEY_DEFAULT);
        idPropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(idPropertyNameConfig);
    }
}

