/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * acosh(1.0) => 0.0
 * acosh(1.0) => 0.0
 * acosh(1.1) => 0.44356832
 * acosh(2.0) => 1.316958
 * acosh(11.0) => 3.08897
 * acosh(10000000000.0) => 23.718998
 */
#version 130

void main()
{
  float[distance(acosh(1.0), 0.0) <= 1e-04 ? 1 : -1] array0;
  float[distance(acosh(1.0), 0.0) <= 1e-04 ? 1 : -1] array1;
  float[distance(acosh(1.1), 0.44356832) <= 0.0004435683 ? 1 : -1] array2;
  float[distance(acosh(2.0), 1.316958) <= 0.0013169579 ? 1 : -1] array3;
  float[distance(acosh(11.0), 3.08897) <= 0.00308897 ? 1 : -1] array4;
  float[distance(acosh(10000000000.0), 23.718998) <= 0.023718998 ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
