/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf)) => dmat4(1.0lf, 3.1329000000000002lf, 0.0081lf, 0.8281000000000001lf, 0.30250000000000005lf, 0.3844lf, 0.5041lf, 3.3124000000000002lf, 1.1664lf, 0.2304lf, 1.9320999999999997lf, 2.0448999999999997lf, 3.2041lf, 1.8225000000000002lf, 1.4641lf, 0.5184lf)
 * matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf)) => dmat4(-0.06lf, 2.8320000000000003lf, 0.11249999999999999lf, 0.1456lf, -0.7205000000000001lf, -0.1984lf, -0.3195lf, -0.8190000000000001lf, -1.6416000000000002lf, 0.2448lf, -2.6409999999999996lf, 1.2584lf, -3.5084lf, 2.4840000000000004lf, 0.8712lf, 0.2808lf)
 * matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf)) => dmat4(-0.06lf, 2.8320000000000003lf, 0.11249999999999999lf, 0.1456lf, -0.7205000000000001lf, -0.1984lf, -0.3195lf, -0.8190000000000001lf, -1.6416000000000002lf, 0.2448lf, -2.6409999999999996lf, 1.2584lf, -3.5084lf, 2.4840000000000004lf, 0.8712lf, 0.2808lf)
 * matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf)) => dmat4(0.0036lf, 2.5600000000000005lf, 1.5625lf, 0.0256lf, 1.7161000000000002lf, 0.1024lf, 0.2025lf, 0.2025lf, 2.3104lf, 0.2601lf, 3.61lf, 0.7744lf, 3.8415999999999997lf, 3.3856lf, 0.5184lf, 0.1521lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(1.0lf, 3.1329000000000002lf, 0.0081lf, 0.8281000000000001lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(1.0lf, 3.1329000000000002lf, 0.0081lf, 0.8281000000000001lf))) + (distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(0.30250000000000005lf, 0.3844lf, 0.5041lf, 3.3124000000000002lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(0.30250000000000005lf, 0.3844lf, 0.5041lf, 3.3124000000000002lf))) + (distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(1.1664lf, 0.2304lf, 1.9320999999999997lf, 2.0448999999999997lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(1.1664lf, 0.2304lf, 1.9320999999999997lf, 2.0448999999999997lf))) + (distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(3.2041lf, 1.8225000000000002lf, 1.4641lf, 0.5184lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(3.2041lf, 1.8225000000000002lf, 1.4641lf, 0.5184lf))) <= 4.829454778000001e-09lf ? 1 : -1] array0;
  double[(distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(-0.06lf, 2.8320000000000003lf, 0.11249999999999999lf, 0.1456lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(-0.06lf, 2.8320000000000003lf, 0.11249999999999999lf, 0.1456lf))) + (distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(-0.7205000000000001lf, -0.1984lf, -0.3195lf, -0.8190000000000001lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(-0.7205000000000001lf, -0.1984lf, -0.3195lf, -0.8190000000000001lf))) + (distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(-1.6416000000000002lf, 0.2448lf, -2.6409999999999996lf, 1.2584lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(-1.6416000000000002lf, 0.2448lf, -2.6409999999999996lf, 1.2584lf))) + (distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(-3.5084lf, 2.4840000000000004lf, 0.8712lf, 0.2808lf)) * distance(matrixCompMult(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(-3.5084lf, 2.4840000000000004lf, 0.8712lf, 0.2808lf))) <= 4.0019197470000005e-09lf ? 1 : -1] array1;
  double[(distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(-0.06lf, 2.8320000000000003lf, 0.11249999999999999lf, 0.1456lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(-0.06lf, 2.8320000000000003lf, 0.11249999999999999lf, 0.1456lf))) + (distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(-0.7205000000000001lf, -0.1984lf, -0.3195lf, -0.8190000000000001lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(-0.7205000000000001lf, -0.1984lf, -0.3195lf, -0.8190000000000001lf))) + (distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(-1.6416000000000002lf, 0.2448lf, -2.6409999999999996lf, 1.2584lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(-1.6416000000000002lf, 0.2448lf, -2.6409999999999996lf, 1.2584lf))) + (distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(-3.5084lf, 2.4840000000000004lf, 0.8712lf, 0.2808lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(-3.5084lf, 2.4840000000000004lf, 0.8712lf, 0.2808lf))) <= 4.0019197470000005e-09lf ? 1 : -1] array2;
  double[(distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(0.0036lf, 2.5600000000000005lf, 1.5625lf, 0.0256lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(0.0036lf, 2.5600000000000005lf, 1.5625lf, 0.0256lf))) + (distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(1.7161000000000002lf, 0.1024lf, 0.2025lf, 0.2025lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(1.7161000000000002lf, 0.1024lf, 0.2025lf, 0.2025lf))) + (distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(2.3104lf, 0.2601lf, 3.61lf, 0.7744lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(2.3104lf, 0.2601lf, 3.61lf, 0.7744lf))) + (distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(3.8415999999999997lf, 3.3856lf, 0.5184lf, 0.1521lf)) * distance(matrixCompMult(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf), dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(3.8415999999999997lf, 3.3856lf, 0.5184lf, 0.1521lf))) <= 5.758261846000001e-09lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
