/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Gl601ProtocolDecoder
extends BaseProtocolDecoder {
    public Gl601ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private int readVariableInt(ByteBuf buf) {
        if (BitUtil.check(buf.getUnsignedByte(buf.readerIndex()), 7)) {
            return buf.readUnsignedShort();
        }
        return buf.readUnsignedByte();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        short flags = buf.readUnsignedByte();
        int count = BitUtil.check(flags, 7) ? buf.readUnsignedShort() : 1;
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        buf.skipBytes((int)buf.readUnsignedByte());
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < count; ++i) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            int recordEndIndex = buf.readerIndex() + this.readVariableInt(buf);
            position.setDeviceTime(new Date(buf.readUnsignedInt() * 1000L));
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            position.set("event", buf.readUnsignedByte());
            while (buf.readerIndex() < recordEndIndex) {
                int dataId = this.readVariableInt(buf);
                int dataEndIndex = this.readVariableInt(buf) + buf.readerIndex();
                switch (dataId) {
                    case 81: 
                    case 82: {
                        short state = buf.readUnsignedByte();
                        position.setValid(BitUtil.between(state, 2, 4) == 2);
                        position.setLongitude((double)buf.readInt() / 1000000.0);
                        position.setLatitude((double)buf.readInt() / 1000000.0);
                        position.setFixTime(new Date(buf.readUnsignedInt() * 1000L));
                        position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() / 10.0));
                        if (dataId != 82) break;
                        position.set("hdop", (double)buf.readUnsignedByte() / 10.0);
                        position.setCourse(buf.readUnsignedShort());
                        position.setAltitude((double)buf.readMedium() / 10.0);
                        position.set("sat", buf.readUnsignedByte());
                        break;
                    }
                    case 97: {
                        buf.readUnsignedByte();
                        position.set("battery", (double)buf.readUnsignedShort() / 1000.0);
                        position.set("batteryLevel", buf.readUnsignedByte());
                        buf.readUnsignedByte();
                    }
                }
                buf.readerIndex(dataEndIndex);
            }
            if (position.getFixTime() == null) {
                this.getLastLocation(position, position.getDeviceTime());
            }
            positions.add(position);
        }
        return positions.isEmpty() ? null : positions;
    }
}

