/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.lib.ui.components.JExtendedSplitPane;

public class JCompoundSplitPane
extends JExtendedSplitPane {
    public JCompoundSplitPane() {
        this.tweakUI();
    }

    public JCompoundSplitPane(int newOrientation) {
        super(newOrientation);
        this.tweakUI();
    }

    public JCompoundSplitPane(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
        this.tweakUI();
    }

    public JCompoundSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.tweakUI();
    }

    public JCompoundSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.tweakUI();
    }

    private Component getFirstComponent() {
        return this.getFirstComponent(this);
    }

    private Component getFirstComponent(JSplitPane splitPane) {
        if (splitPane.getOrientation() == 1) {
            return splitPane.getLeftComponent();
        }
        return splitPane.getTopComponent();
    }

    private Component getSecondComponent() {
        return this.getSecondComponent(this);
    }

    private Component getSecondComponent(JSplitPane splitPane) {
        if (splitPane.getOrientation() == 1) {
            return splitPane.getRightComponent();
        }
        return splitPane.getBottomComponent();
    }

    private void tweakUI() {
        if (!(this.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        if (divider != null) {
            divider.addMouseListener(new DividerMouseListener());
        }
    }

    private class DividerMouseListener
    extends MouseAdapter {
        private double firstResizeWeight = 0.0;
        private double secondResizeWeight = 1.0;

        private DividerMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.configureComponents();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSplitPane firstSplit = (JSplitPane)JCompoundSplitPane.this.getFirstComponent();
                    JSplitPane secondSplit = (JSplitPane)JCompoundSplitPane.this.getSecondComponent();
                    DividerMouseListener.this.firstResizeWeight = firstSplit.getResizeWeight();
                    DividerMouseListener.this.secondResizeWeight = secondSplit.getResizeWeight();
                    firstSplit.setResizeWeight(0.0);
                    secondSplit.setResizeWeight(1.0);
                }
            });
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JSplitPane)JCompoundSplitPane.this.getFirstComponent()).setResizeWeight(DividerMouseListener.this.firstResizeWeight);
                    ((JSplitPane)JCompoundSplitPane.this.getSecondComponent()).setResizeWeight(DividerMouseListener.this.secondResizeWeight);
                }
            });
        }

        private void configureComponents() {
            this.configureFirstComponent();
            this.configureSecondComponent();
        }

        private void configureFirstComponent() {
            JSplitPane firstSplit = (JSplitPane)JCompoundSplitPane.this.getFirstComponent();
            int newWidth = firstSplit.getMinimumSize().width;
            int newHeight = 0;
            newHeight = JCompoundSplitPane.this.getFirstComponent(firstSplit).isVisible() && JCompoundSplitPane.this.getSecondComponent(firstSplit).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)firstSplit).getSize().height + ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)firstSplit).getMinimumSize().height + firstSplit.getDividerSize() : (JCompoundSplitPane.this.getFirstComponent(firstSplit).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)firstSplit).getMinimumSize().height : ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)firstSplit).getMinimumSize().height);
            firstSplit.setMinimumSize(new Dimension(newWidth, newHeight));
        }

        private void configureSecondComponent() {
            JSplitPane secondSplit = (JSplitPane)JCompoundSplitPane.this.getSecondComponent();
            int newWidth = secondSplit.getMinimumSize().width;
            int newHeight = 0;
            newHeight = JCompoundSplitPane.this.getFirstComponent(secondSplit).isVisible() && JCompoundSplitPane.this.getSecondComponent(secondSplit).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)secondSplit).getSize().height + (JCompoundSplitPane.this.getFirstComponent(secondSplit).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)secondSplit).getMinimumSize().height + secondSplit.getDividerSize() : 0) : (JCompoundSplitPane.this.getFirstComponent(secondSplit).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)secondSplit).getMinimumSize().height : ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)secondSplit).getMinimumSize().height);
            secondSplit.setMinimumSize(new Dimension(newWidth, newHeight));
        }
    }
}

