/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.TextMessageTextHandler;
import nu.validator.messages.types.MessageType;
import org.xml.sax.SAXException;

public class GnuMessageEmitter
extends MessageEmitter {
    private final Writer writer;
    private final TextMessageTextHandler messageTextHandler;
    private char[] fileName;

    private static Writer newOutputStreamWriter(OutputStream out) {
        CharsetEncoder enc = Charset.forName("UTF-8").newEncoder();
        enc.onMalformedInput(CodingErrorAction.REPLACE);
        enc.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new OutputStreamWriter(out, enc);
    }

    public GnuMessageEmitter(OutputStream out, boolean asciiQuotes) {
        this.writer = GnuMessageEmitter.newOutputStreamWriter(out);
        this.messageTextHandler = new TextMessageTextHandler(this.writer, asciiQuotes);
    }

    @Override
    public void startMessage(MessageType type, String systemId, int oneBasedFirstLine, int oneBasedFirstColumn, int oneBasedLastLine, int oneBasedLastColumn, boolean exact) throws SAXException {
        try {
            this.writer.flush();
            if (systemId == null) {
                if (this.fileName != null) {
                    this.writer.write(this.fileName, 0, this.fileName.length);
                }
            } else {
                this.writer.write(this.toCString(systemId));
            }
            this.writer.write(58);
            if (oneBasedLastLine != -1) {
                if (oneBasedFirstLine != -1) {
                    this.writer.write(Integer.toString(oneBasedFirstLine));
                    if (oneBasedFirstColumn != -1 && oneBasedLastColumn != -1) {
                        this.writer.write(46);
                        this.writer.write(Integer.toString(oneBasedFirstColumn));
                    }
                    this.writer.write(45);
                }
                this.writer.write(Integer.toString(oneBasedLastLine));
                if (oneBasedFirstColumn != -1 && oneBasedLastColumn != -1) {
                    this.writer.write(46);
                    this.writer.write(Integer.toString(oneBasedLastColumn));
                }
                this.writer.write(58);
            }
            this.writer.write(32);
            this.writer.write(type.getFlatType());
            this.writer.write(58);
            this.writer.write(32);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endMessages(String language) throws SAXException {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startMessages(String documentUri, boolean willShowSource) throws SAXException {
        this.fileName = (char[])(documentUri == null ? null : this.toCString(documentUri));
    }

    private char[] toCString(String documentUri) {
        StringBuilder sb = new StringBuilder(documentUri.length() + 2);
        sb.append('\"');
        for (int i = 0; i < documentUri.length(); ++i) {
            char c = documentUri.charAt(i);
            if (c == '\"') {
                sb.append("%22");
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        char[] rv = new char[sb.length()];
        sb.getChars(0, sb.length(), rv, 0);
        return rv;
    }

    @Override
    public MessageTextHandler startText() throws SAXException {
        return this.messageTextHandler;
    }

    @Override
    public void endMessage() throws SAXException {
        try {
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }
}

