/* Generated by wayland-scanner 1.24.0 */

#ifndef TOUCH_EXTENSION_SERVER_PROTOCOL_H
#define TOUCH_EXTENSION_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_touch_extension The touch_extension protocol
 * @section page_ifaces_touch_extension Interfaces
 * - @subpage page_iface_qt_touch_extension - 
 * @section page_copyright_touch_extension Copyright
 * <pre>
 *
 * Copyright (C) 2015 The Qt Company Ltd.
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause
 * </pre>
 */
struct qt_touch_extension;

#ifndef QT_TOUCH_EXTENSION_INTERFACE
#define QT_TOUCH_EXTENSION_INTERFACE
/**
 * @page page_iface_qt_touch_extension qt_touch_extension
 * @section page_iface_qt_touch_extension_api API
 * See @ref iface_qt_touch_extension.
 */
/**
 * @defgroup iface_qt_touch_extension The qt_touch_extension interface
 */
extern const struct wl_interface qt_touch_extension_interface;
#endif

#ifndef QT_TOUCH_EXTENSION_FLAGS_ENUM
#define QT_TOUCH_EXTENSION_FLAGS_ENUM
enum qt_touch_extension_flags {
	QT_TOUCH_EXTENSION_FLAGS_MOUSE_FROM_TOUCH = 0x1,
};
#endif /* QT_TOUCH_EXTENSION_FLAGS_ENUM */

#ifndef QT_TOUCH_EXTENSION_FLAGS_ENUM_IS_VALID
#define QT_TOUCH_EXTENSION_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_qt_touch_extension
 * Validate a qt_touch_extension flags value.
 *
 * @return true on success, false on error.
 * @ref qt_touch_extension_flags
 */
static inline bool
qt_touch_extension_flags_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case QT_TOUCH_EXTENSION_FLAGS_MOUSE_FROM_TOUCH:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* QT_TOUCH_EXTENSION_FLAGS_ENUM_IS_VALID */

/**
 * @ingroup iface_qt_touch_extension
 * @struct qt_touch_extension_interface
 */
struct qt_touch_extension_interface {
	/**
	 */
	void (*dummy)(struct wl_client *client,
		      struct wl_resource *resource);
};

#define QT_TOUCH_EXTENSION_TOUCH 0
#define QT_TOUCH_EXTENSION_CONFIGURE 1

/**
 * @ingroup iface_qt_touch_extension
 */
#define QT_TOUCH_EXTENSION_TOUCH_SINCE_VERSION 1
/**
 * @ingroup iface_qt_touch_extension
 */
#define QT_TOUCH_EXTENSION_CONFIGURE_SINCE_VERSION 1

/**
 * @ingroup iface_qt_touch_extension
 */
#define QT_TOUCH_EXTENSION_DUMMY_SINCE_VERSION 1

/**
 * @ingroup iface_qt_touch_extension
 * Sends an touch event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_touch_extension_send_touch(struct wl_resource *resource_, uint32_t time, uint32_t id, uint32_t state, int32_t x, int32_t y, int32_t normalized_x, int32_t normalized_y, int32_t width, int32_t height, uint32_t pressure, int32_t velocity_x, int32_t velocity_y, uint32_t flags, struct wl_array *rawdata)
{
	wl_resource_post_event(resource_, QT_TOUCH_EXTENSION_TOUCH, time, id, state, x, y, normalized_x, normalized_y, width, height, pressure, velocity_x, velocity_y, flags, rawdata);
}

/**
 * @ingroup iface_qt_touch_extension
 * Sends an configure event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_touch_extension_send_configure(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, QT_TOUCH_EXTENSION_CONFIGURE, flags);
}

#ifdef  __cplusplus
}
#endif

#endif
