/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.BuildLogicBuildQueue;
import org.gradle.initialization.buildsrc.BuildBuildSrcBuildOperationType;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public class BuildSourceBuilder {
    private static final BuildBuildSrcBuildOperationType.Result BUILD_BUILDSRC_RESULT = new BuildBuildSrcBuildOperationType.Result(){};
    private final BuildState currentBuild;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildSrcBuildListenerFactory buildSrcBuildListenerFactory;
    private final BuildStateRegistry buildRegistry;
    private final PublicBuildPath publicBuildPath;
    private final BuildLogicBuildQueue buildQueue;

    public BuildSourceBuilder(BuildState currentBuild, BuildOperationRunner buildOperationRunner, BuildSrcBuildListenerFactory buildSrcBuildListenerFactory, BuildStateRegistry buildRegistry, PublicBuildPath publicBuildPath, BuildLogicBuildQueue buildQueue) {
        this.currentBuild = currentBuild;
        this.buildOperationRunner = buildOperationRunner;
        this.buildSrcBuildListenerFactory = buildSrcBuildListenerFactory;
        this.buildRegistry = buildRegistry;
        this.publicBuildPath = publicBuildPath;
        this.buildQueue = buildQueue;
    }

    public ClassPath buildAndGetClassPath(GradleInternal gradle) {
        final StandAloneNestedBuild buildSrcBuild = this.buildRegistry.getBuildSrcNestedBuild(this.currentBuild);
        if (buildSrcBuild == null) {
            return ClassPath.EMPTY;
        }
        return (ClassPath)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<ClassPath>(){

            public ClassPath call(BuildOperationContext context) {
                ClassPath classPath = BuildSourceBuilder.this.buildBuildSrc(buildSrcBuild);
                context.setResult((Object)BUILD_BUILDSRC_RESULT);
                return classPath;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build buildSrc").progressDisplayName("Building buildSrc").details((Object)new BuildBuildSrcBuildOperationType.Details(){

                    public String getBuildPath() {
                        return BuildSourceBuilder.this.publicBuildPath.getBuildPath().toString();
                    }
                });
            }
        });
    }

    private ClassPath buildBuildSrc(StandAloneNestedBuild buildSrcBuild) {
        return this.buildQueue.buildBuildSrc(buildSrcBuild, buildController -> new BuildSrcUpdateFactory(this.buildSrcBuildListenerFactory).create((BuildTreeLifecycleController)buildController));
    }
}

