/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.DrawLines;
import de.escape.quincunx.dxf.DrawSet;
import de.escape.quincunx.dxf.DxfColorModel;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Vector3D;
import java.awt.Color;
import java.awt.Graphics;

public class DrawPolygon
extends DrawLines {
    private static final Vector3D light = new Vector3D(0.5f, 0.4f, 0.76811457f);
    private static final float ambient = 0.33f;
    protected Vector3D normal;

    public DrawPolygon() {
        this.isClosed = true;
    }

    public DrawPolygon(int nr) {
        super(nr);
        this.isClosed = true;
    }

    protected static void drawPolygon(Graphics g, int nrPoints, int[] px, int[] py, int[] pz, Color col) {
        int i = 0;
        while (i < nrPoints) {
            if (pz[i] <= 0) {
                return;
            }
            ++i;
        }
        g.setColor(col);
        g.fillPolygon(px, py, nrPoints);
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insertLayer, DxfColorModel colors, short insertColor) {
        super.draw(g, mat, insertLayer, colors, insertColor);
    }

    public void transformBy(Matrix4D mat) {
        super.transformBy(mat);
        if (this.normal != null) {
            this.calcNormal(mat.mult(this.normal));
        }
    }

    public DrawAble extrude(float dist, Vector3D up) {
        boolean right;
        if (dist == 0.0f) {
            return this;
        }
        Vector3D ex = new Vector3D(dist * up.x, dist * up.y, dist * up.z);
        if (this.normal == null) {
            this.calcNormal();
        }
        boolean bl = right = this.normal.mult(ex) > 0.0f;
        if (right) {
            this.normal.scale(-1.0f);
        }
        DrawSet set = new DrawSet(2 + this.nrPoints);
        DrawPolygon second = new DrawPolygon(this.nrPoints);
        set.setLayer(this.layer);
        set.setColor(this.color);
        second.setLayer(this.layer);
        second.setColor(this.color);
        set.addDrawable(this);
        int i = 0;
        while (i < this.nrPoints) {
            second.addPoint(this.line[i].x + ex.x, this.line[i].y + ex.y, this.line[i].z + ex.z);
            ++i;
        }
        if (this.normal != null) {
            Vector3D norm = new Vector3D(this.normal);
            norm.scale(-1.0f);
            second.setNormal(norm);
        }
        set.addDrawable(second);
        int i2 = 0;
        while (i2 < this.nrPoints) {
            DrawPolygon conn = new DrawPolygon(4);
            conn.setLayer(this.layer);
            conn.setColor(this.color);
            conn.addPoint(this.line[i2]);
            if (right) {
                conn.addPoint(this.line[(i2 + 1) % this.nrPoints]);
                conn.addPoint(second.line[(i2 + 1) % this.nrPoints]);
                conn.addPoint(second.line[i2]);
            } else {
                conn.addPoint(second.line[i2]);
                conn.addPoint(second.line[(i2 + 1) % this.nrPoints]);
                conn.addPoint(this.line[(i2 + 1) % this.nrPoints]);
            }
            conn.calcNormal();
            set.addDrawable(conn);
            ++i2;
        }
        return set;
    }

    public void calcNormal() {
        if (this.nrPoints >= 3) {
            int mid = 0;
            do {
                int left = (mid + this.nrPoints - 1) % this.nrPoints;
                int right = (mid + this.nrPoints + 1) % this.nrPoints;
                Vector3D one = this.line[left].minus(this.line[mid]);
                Vector3D two = this.line[right].minus(this.line[mid]);
                this.normal = two.cross(one);
                float len = this.normal.length();
                if (len != 0.0f) {
                    this.normal.scale(1.0f / len);
                    continue;
                }
                this.normal = null;
            } while (this.normal == null && ++mid < this.nrPoints);
        }
    }

    public void calcNormal(Vector3D norm) {
        this.calcNormal();
        if (this.normal != null && this.normal.mult(norm) < 0.0f) {
            this.normal.scale(-1.0f);
        }
    }

    public void setNormal(Vector3D norm) {
        this.normal = new Vector3D(norm);
    }

    public Vector3D getNormal() {
        if (this.normal != null) {
            return new Vector3D(this.normal);
        }
        return null;
    }
}

