/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import tr.extract.Extract;
import tr.extract.ExtractActions;
import tr.extract.criteria.ValueIDsProviderEnergy;
import tr.extract.criteria.ValueIDsProviderPriority;
import tr.extract.criteria.ValueIDsProviderTime;
import tr.model.Data;
import tr.model.action.Action;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.thought.Thought;

public class ExtractProjects {
    private static final Logger LOG = Logger.getLogger("tr.extract");
    private static final DateFormat DFN = Constants.DATE_FORMAT_FIXED;
    private static final DateFormat DFT = Constants.DATE_TIME_FORMAT_FIXED;
    private static List<Integer> timeIDs;
    private static List<Integer> energyIDs;
    private static List<Integer> priorityIDs;

    public static void process(Data data, File xmlfile) {
        timeIDs = ValueIDsProviderTime.instance.getIDs();
        energyIDs = ValueIDsProviderEnergy.instance.getIDs();
        priorityIDs = ValueIDsProviderPriority.instance.getIDs();
        try {
            Writer out = ExtractProjects.initialise(xmlfile);
            ExtractProjects.process(data, out);
            ExtractProjects.finalise(out);
        }
        catch (Exception ex) {
            LOG.severe("Extracting data failed: " + ex.getMessage());
        }
    }

    private static Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<data>\r\n");
        return out;
    }

    private static void finalise(Writer out) throws Exception {
        out.write("</data>\r\n");
        out.flush();
        out.close();
    }

    public static void process(Data data, Writer out) {
        try {
            LOG.info("Extracting projects ... ");
            ExtractProjects.processData(data, out);
            LOG.info("Extracting projects ... done");
        }
        catch (Exception ex) {
            LOG.severe("Extracting projects failed: " + ex.getMessage());
        }
    }

    private static void processData(Data data, Writer out) throws Exception {
        out.write("<projects>\r\n");
        ExtractProjects.processProjects(data, out);
        out.write("</projects>\r\n");
    }

    private static void processProjects(Data data, Writer out) throws Exception {
        for (Project project : data.getRootProjects().getChildren(Project.class)) {
            ExtractProjects.extractProject(project, out);
        }
    }

    public static void extractProject(Project project, Writer out) throws Exception {
        Value priority;
        out.write("<project>\r\n");
        out.write("<created>" + DFN.format(project.getCreated()) + "</created>\r\n");
        Thought thought = project.getThought();
        if (thought != null) {
            out.write("<thought>" + ExtractProjects.escape(thought.getDescription()) + "</thought>\r\n");
        }
        out.write("<topic>" + ExtractProjects.escape(project.getTopic().getName()) + "</topic>\r\n");
        out.write("<desc>" + ExtractProjects.escape(project.getDescription()) + "</desc>\r\n");
        out.write("<purpose>" + ExtractProjects.escape(project.getPurpose()) + "</purpose>\r\n");
        out.write("<success>" + ExtractProjects.escape(project.getVision()) + "</success>\r\n");
        out.write("<brainstorming>" + ExtractProjects.escape(project.getBrainstorming()) + "</brainstorming>\r\n");
        out.write("<organising>" + ExtractProjects.escape(project.getOrganising()) + "</organising>\r\n");
        out.write("<notes>" + ExtractProjects.escape(project.getNotes().trim()) + "</notes>\r\n");
        out.write("<done>" + project.isDone() + "</done>\r\n");
        if (project.getDoneDate() != null) {
            out.write("<done_date>" + DFN.format(project.getDoneDate()) + "</done_date>\r\n");
        }
        if ((priority = project.getPriority()) == null) {
            out.write("<priority></priority>\r\n");
            out.write("<priority-idx>2147483647</priority-idx>\r\n");
        } else {
            out.write("<priority>" + ExtractProjects.escape(priority.getName()) + "</priority>\r\n");
            out.write("<priority-idx>" + ValueIDsProviderPriority.instance.getIDs().indexOf(priority.getID()) + "</priority-idx>\r\n");
        }
        Date startDate = project.getStartDate();
        out.write("<start-date-idx>" + (startDate == null ? Long.MAX_VALUE : startDate.getTime()) + "</start-date-idx>\r\n");
        out.write("<start-date>" + (startDate == null ? "" : DFN.format(startDate)) + "</start-date>\r\n");
        Date dueDate = project.getDueDate();
        out.write("<due-date-idx>" + (dueDate == null ? Long.MAX_VALUE : dueDate.getTime()) + "</due-date-idx>\r\n");
        out.write("<due-date>" + (dueDate == null ? "" : DFN.format(dueDate)) + "</due-date>\r\n");
        for (Action action : project.getChildren(Action.class)) {
            ExtractActions.extractAction(action, out);
        }
        for (Project subproject : project.getChildren(Project.class)) {
            ExtractProjects.extractProject(subproject, out);
        }
        out.write("</project>\r\n");
    }

    private static String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }
}

