untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVZ7ZEIUeP5fNbhK5d9U5bHuM7i3eo3Wumju8hiCkZvzARudEIgv4kC7QYBYZn5w/Qcw/au4zZbdOWjFhRPhycwc=

OpenBSD 7.7 errata 001, May 5, 2025:

Kernel of NFS server could crash if nfsd(8) is enabled and an evil
NFS request is sent to it.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 001_nfs.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/nfs/nfs_serv.c
===================================================================
RCS file: /cvs/src/sys/nfs/nfs_serv.c,v
diff -u -p -r1.131 nfs_serv.c
--- sys/nfs/nfs_serv.c	5 Nov 2024 06:03:19 -0000	1.131
+++ sys/nfs/nfs_serv.c	2 May 2025 10:52:46 -0000
@@ -2435,6 +2435,10 @@ nfsrv_readdir(struct nfsrv_descript *nfs
 		siz = xfer;
 	fullsiz = siz;
 	error = nfsrv_fhtovp(fhp, 1, &vp, cred, slp, nam, &rdonly);
+	if (!error && vp->v_type != VDIR) {
+		error = ENOTDIR;
+		vput(vp);
+	}
 	if (error) {
 		if (nfsm_reply(&info, nfsd, slp, mrq, error,
 		    NFSX_UNSIGNED) != 0)
@@ -2653,6 +2657,10 @@ nfsrv_readdirplus(struct nfsrv_descript 
 		siz = xfer;
 	fullsiz = siz;
 	error = nfsrv_fhtovp(fhp, 1, &vp, cred, slp, nam, &rdonly);
+	if (!error && vp->v_type != VDIR) {
+		error = ENOTDIR;
+		vput(vp);
+	}
 	if (error) {
 		if (nfsm_reply(&info, nfsd, slp, mrq, error,
 		    NFSX_UNSIGNED) != 0)
